//------------------------------------------------------------------------------
// Lab.10: Design a lead compensator for the given system using bode plot.
// System is g=K/s(s+2). Design specifications: Kv=20 sec^-1 and PM=45 deg.
//------------------------------------------------------------------------------

//scilab-5.5.0
//Operating System : OS X 10.9.3
 
//Clean the environment
clc;
clear all;
clf;

//Desired specifications
Phi_s=45;
K=40;

//Uncompenstated system
s=poly(0,'s');
g=syslin('c',40/(s*(s+2)));

//Bode plot of the uncompenmsated system
bode(g,0.001,1000)
title('uncompensated system')
gm=g_margin(g)
pm=p_margin(g)
eps1=10;
Phi_m=(Phi_s-pm+eps1)*%pi/180
alpha=(1-sin(Phi_m))/(1+sin(Phi_m))
gain_phi_m=-10*log10(1/alpha)

// Observed frequency at gain_phi_m
wc2=9.3

// Corner frequency
w1=wc2*sqrt(alpha)
w2=wc2/sqrt(alpha)
Gc=(s+w1)/(s+w2)

//The bode plot of compensated system
figure(1);
bode(Gc*g,0.001,1000),
title('Compensated system')
